# Generated by Django 4.0.6 on 2022-07-27 08:15

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import authentik.core.models
import authentik.lib.generators


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("authentik_providers_oauth2", "0012_remove_oauth2provider_verification_keys"),
    ]

    operations = [
        migrations.CreateModel(
            name="DeviceToken",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "expires",
                    models.DateTimeField(default=authentik.core.models.default_token_duration),
                ),
                ("expiring", models.BooleanField(default=True)),
                ("device_code", models.TextField(default=authentik.lib.generators.generate_key)),
                (
                    "user_code",
                    models.TextField(default=authentik.lib.generators.generate_code_fixed_length),
                ),
                ("_scope", models.TextField(default="", verbose_name="Scopes")),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="authentik_providers_oauth2.oauth2provider",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Device Token",
                "verbose_name_plural": "Device Tokens",
            },
        ),
    ]
