# Generated by Django 5.1.9 on 2025-05-14 11:15

from django.apps.registry import Apps
from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def remove_old_authenticated_session_content_type(
    apps: Apps, schema_editor: BaseDatabaseSchemaEditor
):
    db_alias = schema_editor.connection.alias
    ContentType = apps.get_model("contenttypes", "ContentType")

    ContentType.objects.using(db_alias).filter(model="oldauthenticatedsession").delete()


class Migration(migrations.Migration):

    dependencies = [
        ("authentik_core", "0047_delete_oldauthenticatedsession"),
    ]

    operations = [
        migrations.RunPython(
            code=remove_old_authenticated_session_content_type,
        ),
    ]
