# Generated by Django 5.0.7 on 2024-08-01 18:52

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("authentik_core", "0038_source_authentik_c_enabled_d72365_idx"),
    ]

    operations = [
        migrations.AddField(
            model_name="source",
            name="group_matching_mode",
            field=models.TextField(
                choices=[
                    ("identifier", "Use the source-specific identifier"),
                    (
                        "name_link",
                        "Link to a group with identical name. Can have security implications when a group name is used with another source.",
                    ),
                    (
                        "name_deny",
                        "Use the group name, but deny enrollment when the name already exists.",
                    ),
                ],
                default="identifier",
                help_text="How the source determines if an existing group should be used or a new group created.",
            ),
        ),
        migrations.AlterField(
            model_name="group",
            name="name",
            field=models.TextField(verbose_name="name"),
        ),
        migrations.CreateModel(
            name="GroupSourceConnection",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("last_updated", models.DateTimeField(auto_now=True)),
                ("identifier", models.TextField()),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="authentik_core.group"
                    ),
                ),
                (
                    "source",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="authentik_core.source"
                    ),
                ),
            ],
            options={
                "unique_together": {("group", "source")},
            },
        ),
    ]
