/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  BlueprintFile,
  BlueprintInstance,
  BlueprintInstanceRequest,
  GenericError,
  PaginatedBlueprintInstanceList,
  PatchedBlueprintInstanceRequest,
  UsedBy,
  ValidationError,
} from '../models';
import {
    BlueprintFileFromJSON,
    BlueprintFileToJSON,
    BlueprintInstanceFromJSON,
    BlueprintInstanceToJSON,
    BlueprintInstanceRequestFromJSON,
    BlueprintInstanceRequestToJSON,
    GenericErrorFromJSON,
    GenericErrorToJSON,
    PaginatedBlueprintInstanceListFromJSON,
    PaginatedBlueprintInstanceListToJSON,
    PatchedBlueprintInstanceRequestFromJSON,
    PatchedBlueprintInstanceRequestToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
} from '../models';

export interface ManagedBlueprintsApplyCreateRequest {
    instanceUuid: string;
}

export interface ManagedBlueprintsCreateRequest {
    blueprintInstanceRequest: BlueprintInstanceRequest;
}

export interface ManagedBlueprintsDestroyRequest {
    instanceUuid: string;
}

export interface ManagedBlueprintsListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    path?: string;
    search?: string;
}

export interface ManagedBlueprintsPartialUpdateRequest {
    instanceUuid: string;
    patchedBlueprintInstanceRequest?: PatchedBlueprintInstanceRequest;
}

export interface ManagedBlueprintsRetrieveRequest {
    instanceUuid: string;
}

export interface ManagedBlueprintsUpdateRequest {
    instanceUuid: string;
    blueprintInstanceRequest: BlueprintInstanceRequest;
}

export interface ManagedBlueprintsUsedByListRequest {
    instanceUuid: string;
}

/**
 * 
 */
export class ManagedApi extends runtime.BaseAPI {

    /**
     * Apply a blueprint
     */
    async managedBlueprintsApplyCreateRaw(requestParameters: ManagedBlueprintsApplyCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BlueprintInstance>> {
        if (requestParameters.instanceUuid === null || requestParameters.instanceUuid === undefined) {
            throw new runtime.RequiredError('instanceUuid','Required parameter requestParameters.instanceUuid was null or undefined when calling managedBlueprintsApplyCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/{instance_uuid}/apply/`.replace(`{${"instance_uuid"}}`, encodeURIComponent(String(requestParameters.instanceUuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BlueprintInstanceFromJSON(jsonValue));
    }

    /**
     * Apply a blueprint
     */
    async managedBlueprintsApplyCreate(requestParameters: ManagedBlueprintsApplyCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BlueprintInstance> {
        const response = await this.managedBlueprintsApplyCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get blueprints
     */
    async managedBlueprintsAvailableListRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<BlueprintFile>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/available/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(BlueprintFileFromJSON));
    }

    /**
     * Get blueprints
     */
    async managedBlueprintsAvailableList(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<BlueprintFile>> {
        const response = await this.managedBlueprintsAvailableListRaw(initOverrides);
        return await response.value();
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsCreateRaw(requestParameters: ManagedBlueprintsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BlueprintInstance>> {
        if (requestParameters.blueprintInstanceRequest === null || requestParameters.blueprintInstanceRequest === undefined) {
            throw new runtime.RequiredError('blueprintInstanceRequest','Required parameter requestParameters.blueprintInstanceRequest was null or undefined when calling managedBlueprintsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: BlueprintInstanceRequestToJSON(requestParameters.blueprintInstanceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BlueprintInstanceFromJSON(jsonValue));
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsCreate(requestParameters: ManagedBlueprintsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BlueprintInstance> {
        const response = await this.managedBlueprintsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsDestroyRaw(requestParameters: ManagedBlueprintsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.instanceUuid === null || requestParameters.instanceUuid === undefined) {
            throw new runtime.RequiredError('instanceUuid','Required parameter requestParameters.instanceUuid was null or undefined when calling managedBlueprintsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/{instance_uuid}/`.replace(`{${"instance_uuid"}}`, encodeURIComponent(String(requestParameters.instanceUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsDestroy(requestParameters: ManagedBlueprintsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.managedBlueprintsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsListRaw(requestParameters: ManagedBlueprintsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedBlueprintInstanceList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.path !== undefined) {
            queryParameters['path'] = requestParameters.path;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedBlueprintInstanceListFromJSON(jsonValue));
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsList(requestParameters: ManagedBlueprintsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedBlueprintInstanceList> {
        const response = await this.managedBlueprintsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsPartialUpdateRaw(requestParameters: ManagedBlueprintsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BlueprintInstance>> {
        if (requestParameters.instanceUuid === null || requestParameters.instanceUuid === undefined) {
            throw new runtime.RequiredError('instanceUuid','Required parameter requestParameters.instanceUuid was null or undefined when calling managedBlueprintsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/{instance_uuid}/`.replace(`{${"instance_uuid"}}`, encodeURIComponent(String(requestParameters.instanceUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedBlueprintInstanceRequestToJSON(requestParameters.patchedBlueprintInstanceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BlueprintInstanceFromJSON(jsonValue));
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsPartialUpdate(requestParameters: ManagedBlueprintsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BlueprintInstance> {
        const response = await this.managedBlueprintsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsRetrieveRaw(requestParameters: ManagedBlueprintsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BlueprintInstance>> {
        if (requestParameters.instanceUuid === null || requestParameters.instanceUuid === undefined) {
            throw new runtime.RequiredError('instanceUuid','Required parameter requestParameters.instanceUuid was null or undefined when calling managedBlueprintsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/{instance_uuid}/`.replace(`{${"instance_uuid"}}`, encodeURIComponent(String(requestParameters.instanceUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BlueprintInstanceFromJSON(jsonValue));
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsRetrieve(requestParameters: ManagedBlueprintsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BlueprintInstance> {
        const response = await this.managedBlueprintsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsUpdateRaw(requestParameters: ManagedBlueprintsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BlueprintInstance>> {
        if (requestParameters.instanceUuid === null || requestParameters.instanceUuid === undefined) {
            throw new runtime.RequiredError('instanceUuid','Required parameter requestParameters.instanceUuid was null or undefined when calling managedBlueprintsUpdate.');
        }

        if (requestParameters.blueprintInstanceRequest === null || requestParameters.blueprintInstanceRequest === undefined) {
            throw new runtime.RequiredError('blueprintInstanceRequest','Required parameter requestParameters.blueprintInstanceRequest was null or undefined when calling managedBlueprintsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/{instance_uuid}/`.replace(`{${"instance_uuid"}}`, encodeURIComponent(String(requestParameters.instanceUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: BlueprintInstanceRequestToJSON(requestParameters.blueprintInstanceRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BlueprintInstanceFromJSON(jsonValue));
    }

    /**
     * Blueprint instances
     */
    async managedBlueprintsUpdate(requestParameters: ManagedBlueprintsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BlueprintInstance> {
        const response = await this.managedBlueprintsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async managedBlueprintsUsedByListRaw(requestParameters: ManagedBlueprintsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.instanceUuid === null || requestParameters.instanceUuid === undefined) {
            throw new runtime.RequiredError('instanceUuid','Required parameter requestParameters.instanceUuid was null or undefined when calling managedBlueprintsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/managed/blueprints/{instance_uuid}/used_by/`.replace(`{${"instance_uuid"}}`, encodeURIComponent(String(requestParameters.instanceUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async managedBlueprintsUsedByList(requestParameters: ManagedBlueprintsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.managedBlueprintsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
