/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { DigestAlgorithmEnum } from './DigestAlgorithmEnum';
import type { SignatureAlgorithmEnum } from './SignatureAlgorithmEnum';
import type { SpBindingEnum } from './SpBindingEnum';
/**
 * SAMLProvider Serializer
 * @export
 * @interface SAMLProvider
 */
export interface SAMLProvider {
    /**
     *
     * @type {number}
     * @memberof SAMLProvider
     */
    readonly pk: number;
    /**
     *
     * @type {string}
     * @memberof SAMLProvider
     */
    name: string;
    /**
     * Flow used for authentication when the associated application is accessed by an un-authenticated user.
     * @type {string}
     * @memberof SAMLProvider
     */
    authenticationFlow?: string | null;
    /**
     * Flow used when authorizing this provider.
     * @type {string}
     * @memberof SAMLProvider
     */
    authorizationFlow: string;
    /**
     *
     * @type {Array<string>}
     * @memberof SAMLProvider
     */
    propertyMappings?: Array<string>;
    /**
     * Get object component so that we know how to edit the object
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly component: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly assignedApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly assignedApplicationName: string;
    /**
     * Internal application name, used in URLs.
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly assignedBackchannelApplicationSlug: string;
    /**
     * Application's display Name.
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly assignedBackchannelApplicationName: string;
    /**
     * Return object's verbose_name
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly verboseName: string;
    /**
     * Return object's plural verbose_name
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly verboseNamePlural: string;
    /**
     * Return internal model name
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly metaModelName: string;
    /**
     *
     * @type {string}
     * @memberof SAMLProvider
     */
    acsUrl: string;
    /**
     * Value of the audience restriction field of the assertion. When left empty, no audience restriction will be added.
     * @type {string}
     * @memberof SAMLProvider
     */
    audience?: string;
    /**
     * Also known as EntityID
     * @type {string}
     * @memberof SAMLProvider
     */
    issuer?: string;
    /**
     * Assertion valid not before current time + this value (Format: hours=-1;minutes=-2;seconds=-3).
     * @type {string}
     * @memberof SAMLProvider
     */
    assertionValidNotBefore?: string;
    /**
     * Assertion not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLProvider
     */
    assertionValidNotOnOrAfter?: string;
    /**
     * Session not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).
     * @type {string}
     * @memberof SAMLProvider
     */
    sessionValidNotOnOrAfter?: string;
    /**
     * Configure how the NameID value will be created. When left empty, the NameIDPolicy of the incoming request will be considered
     * @type {string}
     * @memberof SAMLProvider
     */
    nameIdMapping?: string | null;
    /**
     *
     * @type {DigestAlgorithmEnum}
     * @memberof SAMLProvider
     */
    digestAlgorithm?: DigestAlgorithmEnum;
    /**
     *
     * @type {SignatureAlgorithmEnum}
     * @memberof SAMLProvider
     */
    signatureAlgorithm?: SignatureAlgorithmEnum;
    /**
     * Keypair used to sign outgoing Responses going to the Service Provider.
     * @type {string}
     * @memberof SAMLProvider
     */
    signingKp?: string | null;
    /**
     * When selected, incoming assertion's Signatures will be validated against this certificate. To allow unsigned Requests, leave on default.
     * @type {string}
     * @memberof SAMLProvider
     */
    verificationKp?: string | null;
    /**
     *
     * @type {SpBindingEnum}
     * @memberof SAMLProvider
     */
    spBinding?: SpBindingEnum;
    /**
     * Default relay_state value for IDP-initiated logins
     * @type {string}
     * @memberof SAMLProvider
     */
    defaultRelayState?: string;
    /**
     * Get metadata download URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlDownloadMetadata: string;
    /**
     * Get SSO Post URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSsoPost: string;
    /**
     * Get SSO Redirect URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSsoRedirect: string;
    /**
     * Get SSO IDP-Initiated URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSsoInit: string;
    /**
     * Get SLO POST URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSloPost: string;
    /**
     * Get SLO redirect URL
     * @type {string}
     * @memberof SAMLProvider
     */
    readonly urlSloRedirect: string;
}
/**
 * Check if a given object implements the SAMLProvider interface.
 */
export declare function instanceOfSAMLProvider(value: object): boolean;
export declare function SAMLProviderFromJSON(json: any): SAMLProvider;
export declare function SAMLProviderFromJSONTyped(json: any, ignoreDiscriminator: boolean): SAMLProvider;
export declare function SAMLProviderToJSON(value?: SAMLProvider | null): any;
