"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PoliciesEventMatcherListActionEnum = exports.PoliciesApi = void 0;
const runtime = require("../runtime");
const models_1 = require("../models");
/**
 *
 */
class PoliciesApi extends runtime.BaseAPI {
    /**
     * Clear policy cache
     */
    policiesAllCacheClearCreateRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/all/cache_clear/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Clear policy cache
     */
    policiesAllCacheClearCreate(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesAllCacheClearCreateRaw(initOverrides);
        });
    }
    /**
     * Info about cached policies
     */
    policiesAllCacheInfoRetrieveRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/all/cache_info/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.CacheFromJSON)(jsonValue));
        });
    }
    /**
     * Info about cached policies
     */
    policiesAllCacheInfoRetrieve(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesAllCacheInfoRetrieveRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * Policy Viewset
     */
    policiesAllDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesAllDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/all/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Policy Viewset
     */
    policiesAllDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesAllDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Policy Viewset
     */
    policiesAllListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.bindingsIsnull !== undefined) {
                queryParameters['bindings__isnull'] = requestParameters.bindingsIsnull;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.promptstageIsnull !== undefined) {
                queryParameters['promptstage__isnull'] = requestParameters.promptstageIsnull;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/all/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPolicyListFromJSON)(jsonValue));
        });
    }
    /**
     * Policy Viewset
     */
    policiesAllList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesAllListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Policy Viewset
     */
    policiesAllRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesAllRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/all/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Policy Viewset
     */
    policiesAllRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesAllRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Test policy
     */
    policiesAllTestCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesAllTestCreate.');
            }
            if (requestParameters.policyTestRequest === null || requestParameters.policyTestRequest === undefined) {
                throw new runtime.RequiredError('policyTestRequest', 'Required parameter requestParameters.policyTestRequest was null or undefined when calling policiesAllTestCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/all/{policy_uuid}/test/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PolicyTestRequestToJSON)(requestParameters.policyTestRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PolicyTestResultFromJSON)(jsonValue));
        });
    }
    /**
     * Test policy
     */
    policiesAllTestCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesAllTestCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get all creatable types
     */
    policiesAllTypesListRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/all/types/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.TypeCreateFromJSON));
        });
    }
    /**
     * Get all creatable types
     */
    policiesAllTypesList(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesAllTypesListRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesAllUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesAllUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/all/{policy_uuid}/used_by/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesAllUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesAllUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyBindingRequest === null || requestParameters.policyBindingRequest === undefined) {
                throw new runtime.RequiredError('policyBindingRequest', 'Required parameter requestParameters.policyBindingRequest was null or undefined when calling policiesBindingsCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/bindings/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PolicyBindingRequestToJSON)(requestParameters.policyBindingRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PolicyBindingFromJSON)(jsonValue));
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesBindingsCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyBindingUuid === null || requestParameters.policyBindingUuid === undefined) {
                throw new runtime.RequiredError('policyBindingUuid', 'Required parameter requestParameters.policyBindingUuid was null or undefined when calling policiesBindingsDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/bindings/{policy_binding_uuid}/`.replace(`{${"policy_binding_uuid"}}`, encodeURIComponent(String(requestParameters.policyBindingUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesBindingsDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.enabled !== undefined) {
                queryParameters['enabled'] = requestParameters.enabled;
            }
            if (requestParameters.order !== undefined) {
                queryParameters['order'] = requestParameters.order;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policy !== undefined) {
                queryParameters['policy'] = requestParameters.policy;
            }
            if (requestParameters.policyIsnull !== undefined) {
                queryParameters['policy__isnull'] = requestParameters.policyIsnull;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.target !== undefined) {
                queryParameters['target'] = requestParameters.target;
            }
            if (requestParameters.targetIn) {
                queryParameters['target_in'] = requestParameters.targetIn;
            }
            if (requestParameters.timeout !== undefined) {
                queryParameters['timeout'] = requestParameters.timeout;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/bindings/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPolicyBindingListFromJSON)(jsonValue));
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesBindingsListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyBindingUuid === null || requestParameters.policyBindingUuid === undefined) {
                throw new runtime.RequiredError('policyBindingUuid', 'Required parameter requestParameters.policyBindingUuid was null or undefined when calling policiesBindingsPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/bindings/{policy_binding_uuid}/`.replace(`{${"policy_binding_uuid"}}`, encodeURIComponent(String(requestParameters.policyBindingUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedPolicyBindingRequestToJSON)(requestParameters.patchedPolicyBindingRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PolicyBindingFromJSON)(jsonValue));
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesBindingsPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyBindingUuid === null || requestParameters.policyBindingUuid === undefined) {
                throw new runtime.RequiredError('policyBindingUuid', 'Required parameter requestParameters.policyBindingUuid was null or undefined when calling policiesBindingsRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/bindings/{policy_binding_uuid}/`.replace(`{${"policy_binding_uuid"}}`, encodeURIComponent(String(requestParameters.policyBindingUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PolicyBindingFromJSON)(jsonValue));
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesBindingsRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyBindingUuid === null || requestParameters.policyBindingUuid === undefined) {
                throw new runtime.RequiredError('policyBindingUuid', 'Required parameter requestParameters.policyBindingUuid was null or undefined when calling policiesBindingsUpdate.');
            }
            if (requestParameters.policyBindingRequest === null || requestParameters.policyBindingRequest === undefined) {
                throw new runtime.RequiredError('policyBindingRequest', 'Required parameter requestParameters.policyBindingRequest was null or undefined when calling policiesBindingsUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/bindings/{policy_binding_uuid}/`.replace(`{${"policy_binding_uuid"}}`, encodeURIComponent(String(requestParameters.policyBindingUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PolicyBindingRequestToJSON)(requestParameters.policyBindingRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PolicyBindingFromJSON)(jsonValue));
        });
    }
    /**
     * PolicyBinding Viewset
     */
    policiesBindingsUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesBindingsUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesBindingsUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyBindingUuid === null || requestParameters.policyBindingUuid === undefined) {
                throw new runtime.RequiredError('policyBindingUuid', 'Required parameter requestParameters.policyBindingUuid was null or undefined when calling policiesBindingsUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/bindings/{policy_binding_uuid}/used_by/`.replace(`{${"policy_binding_uuid"}}`, encodeURIComponent(String(requestParameters.policyBindingUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesBindingsUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesBindingsUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.dummyPolicyRequest === null || requestParameters.dummyPolicyRequest === undefined) {
                throw new runtime.RequiredError('dummyPolicyRequest', 'Required parameter requestParameters.dummyPolicyRequest was null or undefined when calling policiesDummyCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/dummy/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DummyPolicyRequestToJSON)(requestParameters.dummyPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DummyPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesDummyCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesDummyDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/dummy/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesDummyDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.created !== undefined) {
                queryParameters['created'] = requestParameters.created.toISOString();
            }
            if (requestParameters.executionLogging !== undefined) {
                queryParameters['execution_logging'] = requestParameters.executionLogging;
            }
            if (requestParameters.lastUpdated !== undefined) {
                queryParameters['last_updated'] = requestParameters.lastUpdated.toISOString();
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policyUuid !== undefined) {
                queryParameters['policy_uuid'] = requestParameters.policyUuid;
            }
            if (requestParameters.result !== undefined) {
                queryParameters['result'] = requestParameters.result;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.waitMax !== undefined) {
                queryParameters['wait_max'] = requestParameters.waitMax;
            }
            if (requestParameters.waitMin !== undefined) {
                queryParameters['wait_min'] = requestParameters.waitMin;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/dummy/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedDummyPolicyListFromJSON)(jsonValue));
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesDummyListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesDummyPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/dummy/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedDummyPolicyRequestToJSON)(requestParameters.patchedDummyPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DummyPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesDummyPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesDummyRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/dummy/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DummyPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesDummyRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesDummyUpdate.');
            }
            if (requestParameters.dummyPolicyRequest === null || requestParameters.dummyPolicyRequest === undefined) {
                throw new runtime.RequiredError('dummyPolicyRequest', 'Required parameter requestParameters.dummyPolicyRequest was null or undefined when calling policiesDummyUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/dummy/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.DummyPolicyRequestToJSON)(requestParameters.dummyPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.DummyPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Dummy Viewset
     */
    policiesDummyUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesDummyUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesDummyUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesDummyUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/dummy/{policy_uuid}/used_by/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesDummyUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesDummyUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.eventMatcherPolicyRequest === null || requestParameters.eventMatcherPolicyRequest === undefined) {
                throw new runtime.RequiredError('eventMatcherPolicyRequest', 'Required parameter requestParameters.eventMatcherPolicyRequest was null or undefined when calling policiesEventMatcherCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/event_matcher/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.EventMatcherPolicyRequestToJSON)(requestParameters.eventMatcherPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.EventMatcherPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesEventMatcherCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesEventMatcherDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/event_matcher/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesEventMatcherDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.action !== undefined) {
                queryParameters['action'] = requestParameters.action;
            }
            if (requestParameters.app !== undefined) {
                queryParameters['app'] = requestParameters.app;
            }
            if (requestParameters.clientIp !== undefined) {
                queryParameters['client_ip'] = requestParameters.clientIp;
            }
            if (requestParameters.created !== undefined) {
                queryParameters['created'] = requestParameters.created.toISOString();
            }
            if (requestParameters.executionLogging !== undefined) {
                queryParameters['execution_logging'] = requestParameters.executionLogging;
            }
            if (requestParameters.lastUpdated !== undefined) {
                queryParameters['last_updated'] = requestParameters.lastUpdated.toISOString();
            }
            if (requestParameters.model !== undefined) {
                queryParameters['model'] = requestParameters.model;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policyUuid !== undefined) {
                queryParameters['policy_uuid'] = requestParameters.policyUuid;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/event_matcher/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedEventMatcherPolicyListFromJSON)(jsonValue));
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesEventMatcherListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesEventMatcherPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/event_matcher/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedEventMatcherPolicyRequestToJSON)(requestParameters.patchedEventMatcherPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.EventMatcherPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesEventMatcherPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesEventMatcherRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/event_matcher/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.EventMatcherPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesEventMatcherRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesEventMatcherUpdate.');
            }
            if (requestParameters.eventMatcherPolicyRequest === null || requestParameters.eventMatcherPolicyRequest === undefined) {
                throw new runtime.RequiredError('eventMatcherPolicyRequest', 'Required parameter requestParameters.eventMatcherPolicyRequest was null or undefined when calling policiesEventMatcherUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/event_matcher/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.EventMatcherPolicyRequestToJSON)(requestParameters.eventMatcherPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.EventMatcherPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Event Matcher Policy Viewset
     */
    policiesEventMatcherUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesEventMatcherUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesEventMatcherUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesEventMatcherUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/event_matcher/{policy_uuid}/used_by/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesEventMatcherUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesEventMatcherUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.expressionPolicyRequest === null || requestParameters.expressionPolicyRequest === undefined) {
                throw new runtime.RequiredError('expressionPolicyRequest', 'Required parameter requestParameters.expressionPolicyRequest was null or undefined when calling policiesExpressionCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/expression/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.ExpressionPolicyRequestToJSON)(requestParameters.expressionPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ExpressionPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesExpressionCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesExpressionDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/expression/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesExpressionDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.created !== undefined) {
                queryParameters['created'] = requestParameters.created.toISOString();
            }
            if (requestParameters.executionLogging !== undefined) {
                queryParameters['execution_logging'] = requestParameters.executionLogging;
            }
            if (requestParameters.expression !== undefined) {
                queryParameters['expression'] = requestParameters.expression;
            }
            if (requestParameters.lastUpdated !== undefined) {
                queryParameters['last_updated'] = requestParameters.lastUpdated.toISOString();
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policyUuid !== undefined) {
                queryParameters['policy_uuid'] = requestParameters.policyUuid;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/expression/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedExpressionPolicyListFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesExpressionListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesExpressionPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/expression/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedExpressionPolicyRequestToJSON)(requestParameters.patchedExpressionPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ExpressionPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesExpressionPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesExpressionRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/expression/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ExpressionPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesExpressionRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesExpressionUpdate.');
            }
            if (requestParameters.expressionPolicyRequest === null || requestParameters.expressionPolicyRequest === undefined) {
                throw new runtime.RequiredError('expressionPolicyRequest', 'Required parameter requestParameters.expressionPolicyRequest was null or undefined when calling policiesExpressionUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/expression/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.ExpressionPolicyRequestToJSON)(requestParameters.expressionPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ExpressionPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Source Viewset
     */
    policiesExpressionUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesExpressionUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesExpressionUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesExpressionUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/expression/{policy_uuid}/used_by/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesExpressionUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesExpressionUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.passwordPolicyRequest === null || requestParameters.passwordPolicyRequest === undefined) {
                throw new runtime.RequiredError('passwordPolicyRequest', 'Required parameter requestParameters.passwordPolicyRequest was null or undefined when calling policiesPasswordCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PasswordPolicyRequestToJSON)(requestParameters.passwordPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesPasswordDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.passwordExpiryPolicyRequest === null || requestParameters.passwordExpiryPolicyRequest === undefined) {
                throw new runtime.RequiredError('passwordExpiryPolicyRequest', 'Required parameter requestParameters.passwordExpiryPolicyRequest was null or undefined when calling policiesPasswordExpiryCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password_expiry/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PasswordExpiryPolicyRequestToJSON)(requestParameters.passwordExpiryPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordExpiryPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordExpiryCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordExpiryDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password_expiry/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesPasswordExpiryDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.created !== undefined) {
                queryParameters['created'] = requestParameters.created.toISOString();
            }
            if (requestParameters.days !== undefined) {
                queryParameters['days'] = requestParameters.days;
            }
            if (requestParameters.denyOnly !== undefined) {
                queryParameters['deny_only'] = requestParameters.denyOnly;
            }
            if (requestParameters.executionLogging !== undefined) {
                queryParameters['execution_logging'] = requestParameters.executionLogging;
            }
            if (requestParameters.lastUpdated !== undefined) {
                queryParameters['last_updated'] = requestParameters.lastUpdated.toISOString();
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policyUuid !== undefined) {
                queryParameters['policy_uuid'] = requestParameters.policyUuid;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password_expiry/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPasswordExpiryPolicyListFromJSON)(jsonValue));
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordExpiryListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordExpiryPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password_expiry/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedPasswordExpiryPolicyRequestToJSON)(requestParameters.patchedPasswordExpiryPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordExpiryPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordExpiryPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordExpiryRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password_expiry/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordExpiryPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordExpiryRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordExpiryUpdate.');
            }
            if (requestParameters.passwordExpiryPolicyRequest === null || requestParameters.passwordExpiryPolicyRequest === undefined) {
                throw new runtime.RequiredError('passwordExpiryPolicyRequest', 'Required parameter requestParameters.passwordExpiryPolicyRequest was null or undefined when calling policiesPasswordExpiryUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password_expiry/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PasswordExpiryPolicyRequestToJSON)(requestParameters.passwordExpiryPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordExpiryPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Password Expiry Viewset
     */
    policiesPasswordExpiryUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordExpiryUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesPasswordExpiryUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordExpiryUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password_expiry/{policy_uuid}/used_by/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesPasswordExpiryUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordExpiryUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.amountDigits !== undefined) {
                queryParameters['amount_digits'] = requestParameters.amountDigits;
            }
            if (requestParameters.amountLowercase !== undefined) {
                queryParameters['amount_lowercase'] = requestParameters.amountLowercase;
            }
            if (requestParameters.amountSymbols !== undefined) {
                queryParameters['amount_symbols'] = requestParameters.amountSymbols;
            }
            if (requestParameters.amountUppercase !== undefined) {
                queryParameters['amount_uppercase'] = requestParameters.amountUppercase;
            }
            if (requestParameters.checkHaveIBeenPwned !== undefined) {
                queryParameters['check_have_i_been_pwned'] = requestParameters.checkHaveIBeenPwned;
            }
            if (requestParameters.checkStaticRules !== undefined) {
                queryParameters['check_static_rules'] = requestParameters.checkStaticRules;
            }
            if (requestParameters.checkZxcvbn !== undefined) {
                queryParameters['check_zxcvbn'] = requestParameters.checkZxcvbn;
            }
            if (requestParameters.created !== undefined) {
                queryParameters['created'] = requestParameters.created.toISOString();
            }
            if (requestParameters.errorMessage !== undefined) {
                queryParameters['error_message'] = requestParameters.errorMessage;
            }
            if (requestParameters.executionLogging !== undefined) {
                queryParameters['execution_logging'] = requestParameters.executionLogging;
            }
            if (requestParameters.hibpAllowedCount !== undefined) {
                queryParameters['hibp_allowed_count'] = requestParameters.hibpAllowedCount;
            }
            if (requestParameters.lastUpdated !== undefined) {
                queryParameters['last_updated'] = requestParameters.lastUpdated.toISOString();
            }
            if (requestParameters.lengthMin !== undefined) {
                queryParameters['length_min'] = requestParameters.lengthMin;
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.passwordField !== undefined) {
                queryParameters['password_field'] = requestParameters.passwordField;
            }
            if (requestParameters.policyUuid !== undefined) {
                queryParameters['policy_uuid'] = requestParameters.policyUuid;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.symbolCharset !== undefined) {
                queryParameters['symbol_charset'] = requestParameters.symbolCharset;
            }
            if (requestParameters.zxcvbnScoreThreshold !== undefined) {
                queryParameters['zxcvbn_score_threshold'] = requestParameters.zxcvbnScoreThreshold;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedPasswordPolicyListFromJSON)(jsonValue));
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedPasswordPolicyRequestToJSON)(requestParameters.patchedPasswordPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordUpdate.');
            }
            if (requestParameters.passwordPolicyRequest === null || requestParameters.passwordPolicyRequest === undefined) {
                throw new runtime.RequiredError('passwordPolicyRequest', 'Required parameter requestParameters.passwordPolicyRequest was null or undefined when calling policiesPasswordUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PasswordPolicyRequestToJSON)(requestParameters.passwordPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PasswordPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Password Policy Viewset
     */
    policiesPasswordUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesPasswordUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesPasswordUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/password/{policy_uuid}/used_by/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesPasswordUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesPasswordUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.reputationPolicyRequest === null || requestParameters.reputationPolicyRequest === undefined) {
                throw new runtime.RequiredError('reputationPolicyRequest', 'Required parameter requestParameters.reputationPolicyRequest was null or undefined when calling policiesReputationCreate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.ReputationPolicyRequestToJSON)(requestParameters.reputationPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ReputationPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationCreate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationCreateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesReputationDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesReputationDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.checkIp !== undefined) {
                queryParameters['check_ip'] = requestParameters.checkIp;
            }
            if (requestParameters.checkUsername !== undefined) {
                queryParameters['check_username'] = requestParameters.checkUsername;
            }
            if (requestParameters.created !== undefined) {
                queryParameters['created'] = requestParameters.created.toISOString();
            }
            if (requestParameters.executionLogging !== undefined) {
                queryParameters['execution_logging'] = requestParameters.executionLogging;
            }
            if (requestParameters.lastUpdated !== undefined) {
                queryParameters['last_updated'] = requestParameters.lastUpdated.toISOString();
            }
            if (requestParameters.name !== undefined) {
                queryParameters['name'] = requestParameters.name;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.policyUuid !== undefined) {
                queryParameters['policy_uuid'] = requestParameters.policyUuid;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            if (requestParameters.threshold !== undefined) {
                queryParameters['threshold'] = requestParameters.threshold;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedReputationPolicyListFromJSON)(jsonValue));
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationPartialUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesReputationPartialUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PATCH',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.PatchedReputationPolicyRequestToJSON)(requestParameters.patchedReputationPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ReputationPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationPartialUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationPartialUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesReputationRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ReputationPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Reputation Viewset
     */
    policiesReputationScoresDestroyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.reputationUuid === null || requestParameters.reputationUuid === undefined) {
                throw new runtime.RequiredError('reputationUuid', 'Required parameter requestParameters.reputationUuid was null or undefined when calling policiesReputationScoresDestroy.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/scores/{reputation_uuid}/`.replace(`{${"reputation_uuid"}}`, encodeURIComponent(String(requestParameters.reputationUuid))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Reputation Viewset
     */
    policiesReputationScoresDestroy(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.policiesReputationScoresDestroyRaw(requestParameters, initOverrides);
        });
    }
    /**
     * Reputation Viewset
     */
    policiesReputationScoresListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters.identifier !== undefined) {
                queryParameters['identifier'] = requestParameters.identifier;
            }
            if (requestParameters.identifierIn) {
                queryParameters['identifier_in'] = requestParameters.identifierIn.join(runtime.COLLECTION_FORMATS["csv"]);
            }
            if (requestParameters.ip !== undefined) {
                queryParameters['ip'] = requestParameters.ip;
            }
            if (requestParameters.ordering !== undefined) {
                queryParameters['ordering'] = requestParameters.ordering;
            }
            if (requestParameters.page !== undefined) {
                queryParameters['page'] = requestParameters.page;
            }
            if (requestParameters.pageSize !== undefined) {
                queryParameters['page_size'] = requestParameters.pageSize;
            }
            if (requestParameters.score !== undefined) {
                queryParameters['score'] = requestParameters.score;
            }
            if (requestParameters.search !== undefined) {
                queryParameters['search'] = requestParameters.search;
            }
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/scores/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.PaginatedReputationListFromJSON)(jsonValue));
        });
    }
    /**
     * Reputation Viewset
     */
    policiesReputationScoresList(requestParameters = {}, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationScoresListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Reputation Viewset
     */
    policiesReputationScoresRetrieveRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.reputationUuid === null || requestParameters.reputationUuid === undefined) {
                throw new runtime.RequiredError('reputationUuid', 'Required parameter requestParameters.reputationUuid was null or undefined when calling policiesReputationScoresRetrieve.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/scores/{reputation_uuid}/`.replace(`{${"reputation_uuid"}}`, encodeURIComponent(String(requestParameters.reputationUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ReputationFromJSON)(jsonValue));
        });
    }
    /**
     * Reputation Viewset
     */
    policiesReputationScoresRetrieve(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationScoresRetrieveRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesReputationScoresUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.reputationUuid === null || requestParameters.reputationUuid === undefined) {
                throw new runtime.RequiredError('reputationUuid', 'Required parameter requestParameters.reputationUuid was null or undefined when calling policiesReputationScoresUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/scores/{reputation_uuid}/used_by/`.replace(`{${"reputation_uuid"}}`, encodeURIComponent(String(requestParameters.reputationUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesReputationScoresUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationScoresUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationUpdateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesReputationUpdate.');
            }
            if (requestParameters.reputationPolicyRequest === null || requestParameters.reputationPolicyRequest === undefined) {
                throw new runtime.RequiredError('reputationPolicyRequest', 'Required parameter requestParameters.reputationPolicyRequest was null or undefined when calling policiesReputationUpdate.');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/{policy_uuid}/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'PUT',
                headers: headerParameters,
                query: queryParameters,
                body: (0, models_1.ReputationPolicyRequestToJSON)(requestParameters.reputationPolicyRequest),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, models_1.ReputationPolicyFromJSON)(jsonValue));
        });
    }
    /**
     * Reputation Policy Viewset
     */
    policiesReputationUpdate(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationUpdateRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesReputationUsedByListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters.policyUuid === null || requestParameters.policyUuid === undefined) {
                throw new runtime.RequiredError('policyUuid', 'Required parameter requestParameters.policyUuid was null or undefined when calling policiesReputationUsedByList.');
            }
            const queryParameters = {};
            const headerParameters = {};
            if (this.configuration && this.configuration.accessToken) {
                const token = this.configuration.accessToken;
                const tokenString = yield token("authentik", []);
                if (tokenString) {
                    headerParameters["Authorization"] = `Bearer ${tokenString}`;
                }
            }
            const response = yield this.request({
                path: `/policies/reputation/{policy_uuid}/used_by/`.replace(`{${"policy_uuid"}}`, encodeURIComponent(String(requestParameters.policyUuid))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(models_1.UsedByFromJSON));
        });
    }
    /**
     * Get a list of all objects that use this object
     */
    policiesReputationUsedByList(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.policiesReputationUsedByListRaw(requestParameters, initOverrides);
            return yield response.value();
        });
    }
}
exports.PoliciesApi = PoliciesApi;
/**
 * @export
 */
exports.PoliciesEventMatcherListActionEnum = {
    AuthorizeApplication: 'authorize_application',
    ConfigurationError: 'configuration_error',
    Custom: 'custom_',
    EmailSent: 'email_sent',
    FlowExecution: 'flow_execution',
    ImpersonationEnded: 'impersonation_ended',
    ImpersonationStarted: 'impersonation_started',
    InvitationUsed: 'invitation_used',
    Login: 'login',
    LoginFailed: 'login_failed',
    Logout: 'logout',
    ModelCreated: 'model_created',
    ModelDeleted: 'model_deleted',
    ModelUpdated: 'model_updated',
    PasswordSet: 'password_set',
    PolicyException: 'policy_exception',
    PolicyExecution: 'policy_execution',
    PropertyMappingException: 'property_mapping_exception',
    SecretRotate: 'secret_rotate',
    SecretView: 'secret_view',
    SourceLinked: 'source_linked',
    SuspiciousRequest: 'suspicious_request',
    SystemException: 'system_exception',
    SystemTaskException: 'system_task_exception',
    SystemTaskExecution: 'system_task_execution',
    UpdateAvailable: 'update_available',
    UserWrite: 'user_write',
    UnknownDefaultOpenApi: '11184809'
};
