# Generated by Django 3.2.6 on 2021-08-23 14:34
from django.apps.registry import Apps
from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor

from authentik.stages.password import BACKEND_INBUILT


def replace_inbuilt(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    PasswordStage = apps.get_model("authentik_stages_password", "passwordstage")
    db_alias = schema_editor.connection.alias

    for stage in PasswordStage.objects.using(db_alias).all():
        if "django.contrib.auth.backends.ModelBackend" not in stage.backends:
            continue
        stage.backends.remove("django.contrib.auth.backends.ModelBackend")
        stage.backends.append(BACKEND_INBUILT)
        stage.backends.sort()
        stage.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_stages_password", "0007_app_password"),
    ]

    operations = [
        migrations.RunPython(replace_inbuilt),
    ]
