# Generated by Django 4.0.3 on 2022-03-26 17:24

import uuid

import django.db.models.deletion
from django.apps.registry import Apps
from django.conf import settings
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor

import authentik.core.models


def migrate_add_name(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    db_alias = schema_editor.connection.alias

    Invitation = apps.get_model("authentik_stages_invitation", "invitation")

    for invite in Invitation.objects.using(db_alias).all():
        invite.name = str(invite.pk)
        invite.save()


class Migration(migrations.Migration):
    replaces = [
        ("authentik_stages_invitation", "0001_initial"),
        ("authentik_stages_invitation", "0002_auto_20201225_2143"),
        ("authentik_stages_invitation", "0003_auto_20201227_1210"),
        ("authentik_stages_invitation", "0004_invitation_single_use"),
        ("authentik_stages_invitation", "0005_auto_20210901_1211"),
        ("authentik_stages_invitation", "0006_invitation_name"),
    ]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("authentik_flows", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="InvitationStage",
            fields=[
                (
                    "stage_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_flows.stage",
                    ),
                ),
                (
                    "continue_flow_without_invitation",
                    models.BooleanField(
                        default=False,
                        help_text=(
                            "If this flag is set, this Stage will jump to the next Stage when no"
                            " Invitation is given. By default this Stage will cancel the Flow when"
                            " no invitation is given."
                        ),
                    ),
                ),
            ],
            options={
                "verbose_name": "Invitation Stage",
                "verbose_name_plural": "Invitation Stages",
            },
            bases=("authentik_flows.stage",),
        ),
        migrations.CreateModel(
            name="Invitation",
            fields=[
                (
                    "invite_uuid",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "expires",
                    models.DateTimeField(default=authentik.core.models.default_token_duration),
                ),
                (
                    "fixed_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Optional fixed data to enforce on user enrollment.",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
                (
                    "single_use",
                    models.BooleanField(
                        default=False,
                        help_text="When enabled, the invitation will be deleted after usage.",
                    ),
                ),
                ("expiring", models.BooleanField(default=True)),
                ("name", models.SlugField(default="")),
            ],
            options={
                "verbose_name": "Invitation",
                "verbose_name_plural": "Invitations",
            },
        ),
        migrations.RunPython(
            code=migrate_add_name,
        ),
        migrations.AlterField(
            model_name="invitation",
            name="name",
            field=models.SlugField(),
            preserve_default=False,
        ),
    ]
