# Generated by Django 3.0.6 on 2020-05-19 22:08

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("authentik_flows", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="EmailStage",
            fields=[
                (
                    "stage_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_flows.Stage",
                    ),
                ),
                ("host", models.TextField(default="localhost")),
                ("port", models.IntegerField(default=25)),
                ("username", models.TextField(blank=True, default="")),
                ("password", models.TextField(blank=True, default="")),
                ("use_tls", models.BooleanField(default=False)),
                ("use_ssl", models.BooleanField(default=False)),
                ("timeout", models.IntegerField(default=10)),
                (
                    "from_address",
                    models.EmailField(default="system@authentik.local", max_length=254),
                ),
                (
                    "token_expiry",
                    models.IntegerField(
                        default=30, help_text="Time in minutes the token sent is valid."
                    ),
                ),
                ("subject", models.TextField(default="authentik")),
                (
                    "template",
                    models.TextField(
                        choices=[
                            (
                                "email/password_reset.html",
                                "Password Reset",
                            ),
                            (
                                "email/account_confirmation.html",
                                "Account Confirmation",
                            ),
                        ],
                        default="email/password_reset.html",
                    ),
                ),
            ],
            options={
                "verbose_name": "Email Stage",
                "verbose_name_plural": "Email Stages",
            },
            bases=("authentik_flows.stage",),
        ),
    ]
