# Generated by Django 3.2 on 2021-05-03 18:59

import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import migrations, models

import authentik.lib.generators


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("authentik_core", "0020_source_user_matching_mode"),
    ]

    operations = [
        migrations.CreateModel(
            name="PlexSource",
            fields=[
                (
                    "source_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.source",
                    ),
                ),
                (
                    "client_id",
                    models.TextField(
                        default=authentik.lib.generators.generate_id,
                        help_text="Client identifier used to talk to Plex.",
                    ),
                ),
                (
                    "allowed_servers",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(),
                        default=list,
                        help_text=(
                            "Which servers a user has to be a member of to be granted access. Empty"
                            " list allows every server."
                        ),
                        size=None,
                    ),
                ),
            ],
            options={
                "verbose_name": "Plex Source",
                "verbose_name_plural": "Plex Sources",
            },
            bases=("authentik_core.source",),
        ),
        migrations.CreateModel(
            name="PlexSourceConnection",
            fields=[
                (
                    "usersourceconnection_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.usersourceconnection",
                    ),
                ),
                ("plex_token", models.TextField()),
                ("identifier", models.TextField()),
            ],
            options={
                "verbose_name": "User Plex Source Connection",
                "verbose_name_plural": "User Plex Source Connections",
            },
            bases=("authentik_core.usersourceconnection",),
        ),
    ]
