# Generated by Django 3.2.5 on 2021-08-21 13:41
from django.apps.registry import Apps
from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def update_provider_types(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    OAuthSource = apps.get_model("authentik_sources_oauth", "oauthsource")

    db_alias = schema_editor.connection.alias

    for source in OAuthSource.objects.using(db_alias).all():
        changed = False
        if source.provider_type == "azure-ad":
            source.provider_type = "azuread"
            changed = True
        if source.provider_type == "openid-connect":
            source.provider_type = "openidconnect"
            changed = True

        if changed:
            source.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_sources_oauth", "0004_auto_20210417_1900"),
    ]

    operations = [
        migrations.RunPython(update_provider_types),
    ]
