# Generated by Django 3.0.6 on 2020-05-19 22:08

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("authentik_core", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="OAuthSource",
            fields=[
                (
                    "source_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.Source",
                    ),
                ),
                ("provider_type", models.CharField(max_length=255)),
                (
                    "request_token_url",
                    models.CharField(blank=True, max_length=255, verbose_name="Request Token URL"),
                ),
                (
                    "authorization_url",
                    models.CharField(max_length=255, verbose_name="Authorization URL"),
                ),
                (
                    "access_token_url",
                    models.CharField(max_length=255, verbose_name="Access Token URL"),
                ),
                (
                    "profile_url",
                    models.CharField(max_length=255, verbose_name="Profile URL"),
                ),
                ("consumer_key", models.TextField()),
                ("consumer_secret", models.TextField()),
            ],
            options={
                "verbose_name": "Generic OAuth Source",
                "verbose_name_plural": "Generic OAuth Sources",
            },
            bases=("authentik_core.source",),
        ),
        migrations.CreateModel(
            name="UserOAuthSourceConnection",
            fields=[
                (
                    "usersourceconnection_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.UserSourceConnection",
                    ),
                ),
                ("identifier", models.CharField(max_length=255)),
                ("access_token", models.TextField(blank=True, default=None, null=True)),
            ],
            options={
                "verbose_name": "User OAuth Source Connection",
                "verbose_name_plural": "User OAuth Source Connections",
            },
            bases=("authentik_core.usersourceconnection",),
        ),
    ]
