# Generated by Django 3.2.8 on 2021-10-10 16:16

import django.db.models.deletion
from django.db import migrations, models

import authentik.lib.utils.time


class Migration(migrations.Migration):
    replaces = [
        ("authentik_providers_saml", "0001_initial"),
        ("authentik_providers_saml", "0002_default_saml_property_mappings"),
        ("authentik_providers_saml", "0003_samlprovider_sp_binding"),
        ("authentik_providers_saml", "0004_auto_20200620_1950"),
        ("authentik_providers_saml", "0005_remove_samlprovider_processor_path"),
    ]

    initial = True

    dependencies = [
        ("authentik_crypto", "0001_initial"),
        ("authentik_core", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="SAMLPropertyMapping",
            fields=[
                (
                    "propertymapping_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.propertymapping",
                    ),
                ),
                ("saml_name", models.TextField(verbose_name="SAML Name")),
                ("friendly_name", models.TextField(blank=True, default=None, null=True)),
            ],
            options={
                "verbose_name": "SAML Property Mapping",
                "verbose_name_plural": "SAML Property Mappings",
            },
            bases=("authentik_core.propertymapping",),
        ),
        migrations.CreateModel(
            name="SAMLProvider",
            fields=[
                (
                    "provider_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_core.provider",
                    ),
                ),
                ("name", models.TextField()),
                ("acs_url", models.URLField(verbose_name="ACS URL")),
                ("audience", models.TextField(default="")),
                ("issuer", models.TextField(help_text="Also known as EntityID")),
                (
                    "assertion_valid_not_before",
                    models.TextField(
                        default="minutes=-5",
                        help_text=(
                            "Assertion valid not before current time + this value (Format:"
                            " hours=-1;minutes=-2;seconds=-3)."
                        ),
                        validators=[authentik.lib.utils.time.timedelta_string_validator],
                    ),
                ),
                (
                    "assertion_valid_not_on_or_after",
                    models.TextField(
                        default="minutes=5",
                        help_text=(
                            "Assertion not valid on or after current time + this value (Format:"
                            " hours=1;minutes=2;seconds=3)."
                        ),
                        validators=[authentik.lib.utils.time.timedelta_string_validator],
                    ),
                ),
                (
                    "session_valid_not_on_or_after",
                    models.TextField(
                        default="minutes=86400",
                        help_text=(
                            "Session not valid on or after current time + this value (Format:"
                            " hours=1;minutes=2;seconds=3)."
                        ),
                        validators=[authentik.lib.utils.time.timedelta_string_validator],
                    ),
                ),
                (
                    "digest_algorithm",
                    models.CharField(
                        choices=[("sha1", "SHA1"), ("sha256", "SHA256")],
                        default="sha256",
                        max_length=50,
                    ),
                ),
                (
                    "signature_algorithm",
                    models.CharField(
                        choices=[
                            ("rsa-sha1", "RSA-SHA1"),
                            ("rsa-sha256", "RSA-SHA256"),
                            ("ecdsa-sha256", "ECDSA-SHA256"),
                            ("dsa-sha1", "DSA-SHA1"),
                        ],
                        default="rsa-sha256",
                        max_length=50,
                    ),
                ),
                (
                    "require_signing",
                    models.BooleanField(
                        default=False,
                        help_text=(
                            "Require Requests to be signed by an X509 Certificate. Must match the"
                            " Certificate selected in `Signing Keypair`."
                        ),
                    ),
                ),
                (
                    "signing_kp",
                    models.ForeignKey(
                        default=None,
                        help_text="Signing is enabled upon selection of a Key Pair.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="authentik_crypto.certificatekeypair",
                        verbose_name="Signing Keypair",
                    ),
                ),
                (
                    "sp_binding",
                    models.TextField(
                        choices=[("redirect", "Redirect"), ("post", "Post")],
                        default="redirect",
                        verbose_name="Service Prodier Binding",
                    ),
                ),
            ],
            options={
                "verbose_name": "SAML Provider",
                "verbose_name_plural": "SAML Providers",
            },
            bases=("authentik_core.provider",),
        ),
    ]
