# Generated by Django 4.1.10 on 2023-07-21 12:54

from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def migrate_user_type_v2(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    db_alias = schema_editor.connection.alias
    User = apps.get_model("authentik_core", "User")

    from authentik.core.models import UserTypes

    for user in User.objects.using(db_alias).all():
        if user.type != "default":
            continue
        user.type = UserTypes.INTERNAL
        user.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_core", "0030_user_type"),
    ]

    operations = [
        migrations.AlterField(
            model_name="user",
            name="type",
            field=models.TextField(
                choices=[
                    ("internal", "Internal"),
                    ("external", "External"),
                    ("service_account", "Service Account"),
                    ("internal_service_account", "Internal Service Account"),
                ],
                default="internal",
            ),
        ),
        migrations.RunPython(migrate_user_type_v2),
    ]
